/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.rsf;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;

public class RsfReportingMachineInfo
extends RsfMachineInfo {
    private static final String TRACE_MASKT = "XRSFMT T";
    private static final String TRACE_MASKF = "XRSFMT F";
    private static final String TRACE_MASKD = "XRSFMT D";
    private final int version = 0;
    private static final long serialVersionUID = 1L;
    private String reportingLocation;
    private String alternateSerial;
    private boolean configFileChecked = false;
    private boolean configFileExists = false;

    public RsfReportingMachineInfo(String machType, String machModel, String machSerial, String reportingMachineLocation, String alternateMachineSerial) throws IllegalArgumentException {
        super(machType, machModel, machSerial);
        if (reportingMachineLocation == null || alternateMachineSerial == null) {
            throw new IllegalArgumentException();
        }
        this.reportingLocation = reportingMachineLocation;
        this.alternateSerial = alternateMachineSerial;
    }

    public static RsfMachineInfo getLocalReportingMachineInfo() throws HException {
        HMC hmc = HMC.getHMC();
        String serial = hmc.getMachineSerial();
        return new RsfMachineInfo(hmc.getMachineType(), hmc.getMachineModel(), serial, true);
    }

    public int getVersion() {
        return 0;
    }

    public String getReportingMachineLocation() {
        return this.reportingLocation;
    }

    public void setReportingMachineLocation(String machineLocation) {
        this.reportingLocation = machineLocation;
    }

    public String getConnectingMachineSerial() {
        return this.alternateSerial;
    }

    public void setReportingMachineSerial(String machineSerial) {
        this.alternateSerial = machineSerial;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof RsfReportingMachineInfo && super.equals((RsfMachineInfo)o) && (this.reportingLocation != null && this.reportingLocation.equals(((RsfReportingMachineInfo)o).reportingLocation) || this.reportingLocation == ((RsfReportingMachineInfo)o).reportingLocation) && (this.alternateSerial != null && this.alternateSerial.equals(((RsfReportingMachineInfo)o).alternateSerial) || this.alternateSerial == ((RsfReportingMachineInfo)o).alternateSerial);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer("<CMINFO>");
        buffer.append(this.formatInfo());
        if (this.reportingLocation != null) {
            buffer.append("<CL>");
            buffer.append(this.reportingLocation);
            buffer.append("</CL>");
        }
        if (this.alternateSerial != null) {
            buffer.append("<CS>");
            buffer.append(this.alternateSerial);
            buffer.append("</CS>");
        }
        buffer.append("</CMINFO>");
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("<CMINFO>");
        buffer.append(this.formatInfo());
        if (this.reportingLocation != null) {
            buffer.append("<CL>");
            buffer.append(this.reportingLocation);
            buffer.append("</CL>");
        }
        if (this.alternateSerial != null) {
            buffer.append("<CS>");
            buffer.append(this.alternateSerial);
            buffer.append("</CS>");
        }
        buffer.append("</CMINFO>\n");
        return buffer.toString();
    }
}

